/*
 * Decompiled with CFR 0.152.
 */
package app;

import util.Logger;

public class ComplexVoltage {
    static Logger logger = Logger.getLogger();
    private double rx;
    private double ry;
    private double qx;
    private double qy;
    private double phi0;

    public ComplexVoltage(double prx, double pry, double pqx, double pqy) {
        this.rx = prx;
        this.ry = pry;
        this.qx = pqx;
        this.qy = pqy;
        this.phi0 = 0.0;
    }

    public double getLertes() {
        double result = 0.0;
        double uz = 2.0 * (this.rx * this.qx + this.ry * this.qy);
        double un = this.rx * this.rx + this.ry * this.ry - this.qx * this.qx - this.qy * this.qy;
        result = 0.5 * Math.atan2(uz, un);
        return result;
    }

    public double getAzi(double tg) {
        double ub;
        double result = 0.0;
        double uxmax = 0.0;
        double uymax = 0.0;
        double uxmin = 0.0;
        double uymin = 0.0;
        double wt0 = this.getLertes();
        double wt1 = wt0 + 1.5707963267948966;
        double pw = wt0 * 180.0 / Math.PI;
        double ux1 = this.qx * Math.sin(wt0) + this.rx * Math.cos(wt0);
        double uy1 = this.qy * Math.sin(wt0) + this.ry * Math.cos(wt0);
        double ux2 = this.qx * Math.sin(wt1) + this.rx * Math.cos(wt1);
        double uy2 = this.qy * Math.sin(wt1) + this.ry * Math.cos(wt1);
        double ua = Math.sqrt(ux1 * ux1 + uy1 * uy1);
        if (ua > (ub = Math.sqrt(ux2 * ux2 + uy2 * uy2))) {
            uxmax = ux1;
            uymax = uy1;
            uxmin = ux2;
            uymin = uy2;
        } else {
            uxmax = ux1;
            uymax = uy2;
            uxmin = ux1;
            uymin = uy1;
        }
        double a0 = Math.atan2(uxmax, uymax) * 180.0 / Math.PI;
        if (a0 < 0.0) {
            a0 += 360.0;
        }
        double ph0 = pw;
        double da0 = a0 - tg;
        if (90.0 < Math.abs(da0) && Math.abs(da0) < 270.0) {
            ph0 = pw - 180.0;
            if (pw < 0.0) {
                ph0 = pw + 180.0;
            }
            if ((a0 -= 180.0) < 0.0) {
                a0 += 360.0;
            }
        }
        if (a0 - tg > 270.0) {
            a0 -= 360.0;
        }
        if (tg - a0 > 270.0) {
            a0 += 360.0;
        }
        this.phi0 = ph0;
        result = a0;
        return result;
    }
}

